"""
Usage: run this script from the root folder

1. run a single test case "name.isq"
$ python benchmark/run.py name

2. run all the cases (with no additional arguments)
$ python benchmark/run.py
"""
import subprocess
import sys

if __name__ == "__main__":
    if len(sys.argv) == 1:
        benchmarks = [
            "mcx",
            "mcx4",
            "mcx5",
            "mcx6",
            "mcx10",
            "mcp",
            "mcp4",
            "mcp5",
            "mcp6",
            "dj",
            "ghz",
            "grover",
            "qft_temp",
            "qft_entangled",
            "qpeexact",
            "qpeinexact",
            "qwalk",
            "shor",
        ]
    else:
        benchmarks = [sys.argv[1]]
    print("name n1 n2")
    for benchmark in benchmarks:
        filename = "benchmark/" + benchmark + ".isq"
        insts = subprocess.run(["bin/isqc", "compile", "--target", "uni", filename], capture_output=True).stdout.decode().split('\n')
        n1 = n2 = 0
        for inst in insts:
            sep = inst.split()
            if sep:
                gate = sep[0]
                if gate == "CNOT" or gate == "CZ":
                    n2 += 1
                elif gate != "M":
                    n1 += 1
        print(benchmark, n1, n2)
