{ pkgs
, vendor ? null
, gitignoreSource ? vendor.gitignoreSource
, isQVersionHook
, isQVersion
, haskellNix
, nixpkgs-haskellNix
}:
let
  src = gitignoreSource ./.;
  crossConfigurations = {
    native = {
      crossPlatforms = p: [ ];
      pkgsCrossFn = (x: x);
    };
    mingwW64 = {
      crossPlatforms = p: [ p.mingwW64 ];
      pkgsCrossFn = (x: x.pkgsCross.mingwW64);
    };
    aarch64-linux = {
      crossPlatforms = p: [ p.aarch64-multiplatform ];
      pkgsCrossFn = (x: x.pkgsCross.aarch64-multiplatform);
    };
  };
  crossConfig = if pkgs.stdenv.hostPlatform.isWindows then crossConfigurations.mingwW64 else if pkgs.stdenv.hostPlatform.isAarch64 && pkgs.stdenv.hostPlatform.isLinux then crossConfigurations.aarch64-linux else crossConfigurations.native;
  inherit (crossConfig) pkgsCrossFn;
  pkgs-haskellNix = import nixpkgs-haskellNix {
    system = pkgs.stdenv.buildPlatform.system;
    overlays = [
      haskellNix.overlay
      (final: prev: {
        isqc1 = final.haskell-nix.hix.project {
          inherit src;
          evalSystem = pkgs.stdenv.buildPlatform.system;
          inherit (crossConfig) crossPlatforms;
        };
        #isqc1Native = final.haskell-nix.hix.project {
        #  inherit src;
        #  evalSystem = pkgs.stdenv.buildPlatform.system;
        #};

      })
    ];
    inherit (haskellNix) config;
  };
  pkgsCross = pkgsCrossFn pkgs-haskellNix;
  isqc1Flake = pkgsCross.isqc1.flake { };
  #isqc1NativeFlake = pkgsCross.isqc1Native.flake { };
  isqc1 = isqc1Flake.packages."isqc1:exe:isqc1";
  #isqc1 = (pkgs.haskellPackages.callCabal2nix "isqc1" src { });
  #inherit (pkgs.haskell.lib) justStaticExecutables;
  #isqc1Static = justStaticExecutables isqc1;
in
isqc1.overrideAttrs (final: prev: {
  doCheck = false;
  nativeBuildInputs = prev.nativeBuildInputs ++ [ isQVersionHook ];
  passthru.isQDevShell = (isqc1Flake.devShells.default);
  /*
    let
      hs_shell = pkgs.haskellPackages.shellFor {
        nativeBuildInputs = with pkgs; [
          haskellPackages.hpack
          haskellPackages.haskell-language-server
          haskellPackages.cabal-install
        ];
        packages = p: [ isqc1Static ];
      };
    in
    pkgs.mkShell {
      inputsFrom = [ hs_shell ];
    };
  */
})
