
use crate::io_error_when;

use super::{File, ISQBinTool};
use super::ext::*;
pub mod resolve;
use std::io::Write;
pub struct ISQC1{
    tool: ISQBinTool,
    include_path: Vec<String>
}

impl ISQC1{
    pub fn new(include_path: &[String])->Self{
        #[cfg(target_os = "windows")]
        let isqc1_executable = "isqc1.bat";
        #[cfg(not(target_os = "windows"))]
        let isqc1_executable = "isqc1";
        Self{
            tool: ISQBinTool::new(isqc1_executable),
            include_path: include_path.to_vec()
        }
    }
    pub fn compile_with_flags(&self, source: &File, qcis: bool)->miette::Result<File>{
        let mlir_output = self.tool.tempfile(mlir_src())?;
        let include_path_all = self.include_path.join(":");
        let mut flags = vec![
            "-i",
            source.path()?
        ];
        if include_path_all!=""{
            flags.extend([
                "-I",
                &include_path_all,
            ]);
        }
        if qcis{
            flags.push("--qcis");
        }
        let isqc1_output = self.tool.call(&flags)?;
        let resolved_mlir = resolve::resolve_isqc1_output(&isqc1_output)?;
        let mut mlir_file = mlir_output.open()?;
        write!(mlir_file, "{}", resolved_mlir).map_err(io_error_when("Writing MLIR"))?;
        Ok(mlir_output)
    }
}