use crate::{io_error_when, tools::{ext::{llvm_bc, llvm_src, object}, File, ISQBinTool}};
use std::io::Write;

pub struct LLC{
    tool: ISQBinTool,
}
impl LLC{
    pub fn new() -> Self{
        Self{
            tool: ISQBinTool::new_llvm("llc")
        }
    }

    pub fn run(&self, input: &File)->miette::Result<File>{
        let obj_out = self.tool.tempfile(object())?;
        let mut llc_args = Vec::new();
        llc_args.push("-filetype=obj");
        llc_args.push("--relocation-model=pic");
        llc_args.push(input.path()?);
        llc_args.push("-o");
        llc_args.push(obj_out.path()?);
        self.tool.call(&llc_args)?;
        Ok(obj_out)
    }
}