use crate::{io_error_when, tools::{ext::{binary, llvm_bc, llvm_src, object}, File, ISQBinTool}};
use std::io::Write;

pub struct LLD{
    tool: ISQBinTool,
}
impl LLD{
    pub fn new() -> Self{
        Self{
            tool: ISQBinTool::new_llvm("lld")
        }
    }

    pub fn run<S: AsRef<str>>(&self, input: &File, ldflags: &[S])->miette::Result<File>{
        let so_out = self.tool.tempfile(&binary()?)?;
        let mut lld_args = Vec::new();
        lld_args.push("-flavor");
        lld_args.push("gnu");
        lld_args.extend(ldflags.iter().map(|s| s.as_ref()));
        lld_args.push(input.path()?);
        lld_args.push("-o");
        lld_args.push(so_out.path()?);
        self.tool.call(&lld_args)?;
        Ok(so_out)
    }
}