use crate::{io_error_when, tools::{ext::{binary, llvm_bc, llvm_src, object}, File, ISQBinTool}};
use std::io::Write;

pub struct LLVMAs{
    tool: ISQBinTool,
}
impl LLVMAs{
    pub fn new() -> Self{
        Self{
            tool: ISQBinTool::new_llvm("llvm-as")
        }
    }

    pub fn run<S: AsRef<str>>(&self, input: &File)->miette::Result<File>{
        let output = self.tool.tempfile(llvm_bc())?;
        let mut args = Vec::new();
        args.push(input.path()?);
        args.push("-o");
        args.push(output.path()?);
        self.tool.call(&args)?;
        Ok(output)
    }
}