use crate::{io_error_when, tools::{ext::{llvm_bc, llvm_src}, File, ISQBinTool}};
use std::io::{BufReader, BufWriter, Write};
pub struct LLVMLink{
    tool: ISQBinTool
}
impl LLVMLink{
    pub fn new() -> Self{
        Self{
            tool: ISQBinTool::new_llvm("llvm-link")
        }
    }
    pub fn link<S: AsRef<str>, F: AsRef<File>>(&self, llvm: &[F], flags: &[S], extra_native_header: Option<&str>)->miette::Result<File>{
        let llvm_bc_out = self.tool.tempfile(llvm_bc())?;
        let mut link_args = Vec::new();
        link_args.extend(flags.iter().map(|x| x.as_ref()));
        let mut files = vec![];
        let mut tempfiles = vec![];
        if let Some(x) = extra_native_header{
            for f in llvm.iter(){
                let tmp = self.tool.tempfile(llvm_src())?;
                let mut fh = tmp.open()?;
                writeln!(fh, "{}", x).map_err(io_error_when("Writing LLVM header"))?;
                let old_fh = f.as_ref().open()?;
                let mut reader = BufReader::with_capacity(0x2000, old_fh);
                let mut writer = BufWriter::with_capacity(0x2000, fh);
                std::io::copy(&mut reader, &mut writer).map_err(io_error_when("Copying LLVM"))?;
                files.push(tmp.path()?.to_owned());
                tempfiles.push(tmp);
            }
        }else{
            for f in llvm.iter(){
                files.push(f.as_ref().path()?.to_owned());
            }
        }
        link_args.extend(files.iter().map(|x| x.as_str()));
        link_args.push("-o");
        link_args.push(llvm_bc_out.path()?);
        self.tool.call(&link_args)?;
        Ok(llvm_bc_out)
    }
}