use crate::{io_error_when, tools::{ext::llvm_src, File, ISQBinTool}};
use std::io::Write;
pub struct MLIRTranslate{
    tool: ISQBinTool
}
impl MLIRTranslate{
    pub fn new() -> Self{
        Self{
            tool: ISQBinTool::new_llvm("mlir-translate")
        }
    }
    pub fn mlir_to_llvmir(&self, mlir: &File)->miette::Result<File>{
        let llvm_out = self.tool.tempfile(llvm_src())?;
        let llvm = self.tool.call(&["--mlir-to-llvmir", mlir.path()?])?;
        let mut f = llvm_out.open()?;
        write!(f, "{}", llvm).map_err(io_error_when("Writing LLVM"))?;
        Ok(llvm_out)
    }
}