use crate::{io_error_when, tools::{ext::{llvm_bc, llvm_src}, File, ISQBinTool}};
use std::io::Write;
#[derive(Clone, Copy)]
pub enum OptFlags{
    O1,
    O2,
    O3
}
impl OptFlags{
    pub fn as_str(&self) -> &'static str{
        match self{
            Self::O1 => "-O1",
            Self::O2 => "-O2",
            Self::O3 => "-O3",
        }
    }
}
pub struct Opt{
    tool: ISQBinTool,
}
impl Opt{
    pub fn new() -> Self{
        Self{
            tool: ISQBinTool::new_llvm("opt")
        }
    }

    pub fn run(&self, input: &File, flags: &[OptFlags])->miette::Result<File>{
        let llvm_bc_out = self.tool.tempfile(llvm_bc())?;
        let mut opt_args = Vec::new();
        opt_args.extend(flags.iter().map(|x| x.as_str()));
        opt_args.push(input.path()?);
        opt_args.push("-o");
        opt_args.push(llvm_bc_out.path()?);
        self.tool.call(&opt_args)?;
        Ok(llvm_bc_out)
    }
}