mod util;
use util::merge;
use assert_cmd::prelude::*; // Add methods on commands
use predicates::prelude::*; // Used for writing assertions
use std::process::Command; // Run programs
use std::path::Path;
use test_case::test_case;

#[test_case("ctrl_oracle", &merge(&["1", "1", "1", "0"]))]
#[test_case("ctrl_deriving_ctrl", &merge(&["0", "1", "1"]))]
#[test_case("ctrl_gphase", &merge(&["1"]))]
#[test_case("deriving_array_ctrl", &merge(&["2"]))]
#[test_case("deriving_ctrl_inv", &merge(&["0"]))]
#[test_case("deriving_inv_ctrl", &merge(&["0"]))]
#[test_case("deriving_inv", &merge(&["0"]))]
#[test_case("deriving_slice_ctrl", &merge(&["6", "2"]))]
#[test_case("inv", &merge(&["0"]))]
#[test_case("two_inv", &merge(&["1"]))]
fn test_decorator(name: &str, res: &str) -> Result<(), Box<dyn std::error::Error>> {
    let source_file = name.to_string() + ".isq";
    let folder = Path::new("tests").join("input").join("decorator");
    let mut cmd = Command::cargo_bin("isqc")?;
    cmd.arg("run").arg("--debug").arg(folder.join(source_file).to_str().to_owned().unwrap());
    cmd.assert().success().stderr(predicate::str::contains(res));
    Ok(())
}
#[test_case("ctrl_s")]
#[test_case("ctrl2_s")]
fn test_decorator_no_error(name: &str) -> Result<(), Box<dyn std::error::Error>> {
    let source_file = name.to_string() + ".isq";
    let folder = Path::new("tests").join("input").join("decorator");
    let mut cmd = Command::cargo_bin("isqc")?;
    cmd.arg("run").arg(folder.join(source_file).to_str().to_owned().unwrap());
    cmd.assert().success().stderr(predicate::str::is_empty());
    Ok(())
}
