mod util;
use util::merge;
use assert_cmd::prelude::*; // Add methods on commands
use predicates::prelude::*; // Used for writing assertions
use std::process::Command; // Run programs
use std::path::Path;
use test_case::test_case;

#[test_case("factorial", &merge(&["24"]))]
#[test_case("fib", &merge(&["8"]))]
#[test_case("let_add", &merge(&["2"]))]
#[test_case("let_if", &merge(&["2"]))]
#[test_case("let_letrec", &merge(&["6"]))]
#[test_case("let_naive", &merge(&["2"]))]
#[test_case("let_nested", &merge(&["4"]))]
#[test_case("let_symbol", &merge(&["1"]))]
#[test_case("let_templ", &merge(&["2"]))]
#[test_case("letrec_let", &merge(&["16"]))]
#[test_case("letrec_naive", &merge(&["2"]))]
#[test_case("letrec_variable", &merge(&["2"]))]
#[test_case("mod_inv", &merge(&["2"]))]
fn test_lambda(name: &str, res: &str) -> Result<(), Box<dyn std::error::Error>> {
    let source_file = name.to_string() + ".isq";
    let folder = Path::new("tests").join("input").join("lambda");
    let mut cmd = Command::cargo_bin("isqc")?;
    cmd.arg("run").arg("--debug").arg(folder.join(source_file).to_str().to_owned().unwrap());
    cmd.assert().success().stderr(predicate::str::contains(res));
    Ok(())
}
