mod util;
use util::merge;
use assert_cmd::prelude::*; // Add methods on commands
use predicates::prelude::*; // Used for writing assertions
use std::process::Command; // Run programs
use std::path::Path;
use test_case::test_case;

#[test_case("arg", &merge(&["2"]))]
#[test_case("complex", &merge(&["8"]))]
#[test_case("decorator", &merge(&["7"]))]
#[test_case("deriving_if", &merge(&["5", "3"]))]
#[test_case("gate_array", &merge(&["0", "3"]))]
#[test_case("gate_array_multi_size", &merge(&["7"]))]
#[test_case("gate_naive", &merge(&["1", "0"]))]
#[test_case("gate_nested", &merge(&["1"]))]
#[test_case("gate_parameter", &merge(&["1", "0"]))]
#[test_case("naive", &merge(&["2", "4"]))]
#[test_case("nested", &merge(&["2"]))]
#[test_case("oracle", &merge(&["0", "1", "1"]))]
#[test_case("recursion", &merge(&["1", "24"]))]
#[test_case("special", &merge(&["-1", "4"]))]
#[test_case("two_gates", &merge(&["0", "0"]))]
#[test_case("two_template_args", &merge(&["2", "1"]))]
fn test_template(name: &str, res: &str) -> Result<(), Box<dyn std::error::Error>> {
    let source_file = name.to_string() + ".isq";
    let folder = Path::new("tests").join("input").join("template");
    let mut cmd = Command::cargo_bin("isqc")?;
    cmd.arg("run").arg("--debug").arg(folder.join(source_file).to_str().to_owned().unwrap());
    cmd.assert().success().stderr(predicate::str::contains(res));
    Ok(())
}
