mod util;
use util::merge;
use assert_cmd::prelude::*; // Add methods on commands
use predicates::prelude::*; // Used for writing assertions
use std::process::Command; // Run programs
use std::path::Path;
use test_case::test_case;

#[test_case("two_array", &merge(&["CNOT Q0 Q3", "CNOT Q1 Q4", "CNOT Q2 Q5"]))]
fn test_uni(name: &str, res: &str) -> Result<(), Box<dyn std::error::Error>> {
    let source_file = name.to_string() + ".isq";
    let folder = Path::new("tests").join("input").join("qcis");
    let mut cmd = Command::cargo_bin("isqc")?;
    cmd.arg("compile").arg("--target").arg("uni").arg(folder.join(source_file).to_str().to_owned().unwrap());
    cmd.assert().success().stdout(predicate::str::contains(res));
    Ok(())
}