{ cmake
, ninja
, doxygen
, graphviz
, python3
, which
, git
, lld
, eigen
, nlohmann_json
, mkShell
, clang-tools
, vendor ? null
, gitignoreSource ? vendor.gitignoreSource
, mlir ? vendor.mlir
, caterpillar ? vendor.caterpillar
, fmt
, isQVersion
, isQVersionHook
, lib
, buildPackages
}:
let
  stdenv = vendor.stdenvBuild;
  eigen_override = eigen.overrideAttrs (final: prev: {
    meta = prev.meta // {
      platforms = lib.platforms.all;
    };
  });
  isq-opt =
    stdenv.mkDerivation {
      pname = "isq-opt";
      inherit (isQVersion) version;
      nativeBuildInputs = [ cmake ninja doxygen graphviz python3 which git isQVersionHook ];
      buildInputs = [
        eigen_override
        mlir
        nlohmann_json
        caterpillar
        fmt
      ];
      src = gitignoreSource ./.;
      cmakeFlags = [ "-DISQ_OPT_ENABLE_ASSERTIONS=1" ] ++ lib.optionals (stdenv.buildPlatform != stdenv.hostPlatform) [
        "-DNATIVE_MLIR_TBLGEN_ROOT=${buildPackages.isqc.vendorPkgs.mlir}"
      ];
      cmakeBuildType = "RelWithDebInfo";
      passthru.isQDevShell = mkShell.override { stdenv = stdenv; } {
        inputsFrom = [ isq-opt ];
        nativeBuildInputs = [ vendor.clang-tools ];
      };
      inherit mlir;
    };
in
isq-opt
