#include "isqast/IR.h"
#include "isq/IR.h"
#include "isq/tblgen/ISQASTDialect.cpp.inc"
#define GET_TYPEDEF_CLASSES
#include <isq/tblgen/ISQASTTypes.cpp.inc>
#define GET_OP_CLASSES
#include "isq/tblgen/ISQASTOPs.cpp.inc"

namespace isq {
    namespace ast {
        void ISQASTDialect::initialize() {
            addTypes<
        #define GET_TYPEDEF_LIST
        #include <isq/tblgen/ISQASTTypes.cpp.inc>
                >();
            addOperations<
        #define GET_OP_LIST
        #include <isq/tblgen/ISQASTOPs.cpp.inc>
                >();
        }

        ::mlir::Type ISQASTDialect::parseType(::mlir::DialectAsmParser& parser) const{
            auto kwLoc = parser.getCurrentLocation();
            mlir::StringRef kw;
            mlir::Type ty;
            auto ret =
                generatedTypeParser(parser, &kw, ty);
            if (!ret.has_value()) {
                parser.emitError(kwLoc, "unrecognized type");
                return nullptr;
            }
            return ty;
        }
        void ISQASTDialect::printType(::mlir::Type type, ::mlir::DialectAsmPrinter& printer) const{
            if (mlir::failed(generatedTypePrinter(type, printer))) {
                llvm_unreachable("bad type for dialect ast.");
            }
        }

    }
}