#include "isq/contrib/Affine.h"
#include "isq/dialects/Extra.h"
#include <mlir/Dialect/Func/Extensions/AllExtensions.h>
#include <mlir/InitAllPasses.h>
#include <mlir/InitAllDialects.h>
#include <isq/IR.h>
#include <isq/passes/Passes.h>
#include "isqast/IR.h"
namespace isq {
namespace ir {
void ISQToolsInitialize(mlir::DialectRegistry &registry) {
    mlir::registerAllPasses();
    mlir::func::registerAllExtensions(registry);
    passes::registerStatePreparation();
    passes::registerDecorateFolding();
    passes::registerQSD();
    passes::registerExpandDecomposition();
    passes::registerGenerateDerivingInverse();
    passes::registerInlineDerivingPass();
    passes::registerInstantiateTemplate();
    passes::registerLowerToQIRRep();
    passes::registerLowerSwitchOp();
    passes::registerQIR2LLVM();
    passes::registerPureGateDetect();
    passes::registerRecognizeFamousGates();
    passes::registerSQRot2U3();
    passes::registerDecomposeCtrlU3();
    passes::registerRemoveTrivialSQGates();
    passes::registerTargetQCISSet();
    passes::registerRemoveGPhase();
    passes::registerRemoveReset();
    passes::registerEliminateNegCtrl();
    passes::registerISQCanonicalizer();
    passes::registerISQ2QCIS();
    passes::registerOracleDecompose();
    passes::registerAffineSWP();
    passes::registerGlobalThreadLocal();
    passes::registerReuseQubit();
    passes::registerRedundant();
    passes::registerPermutationDecompose();
    mlir::registerAllDialects(registry);
    registry.insert<isq::ir::ISQDialect>();
    registry.insert<isq::ast::ISQASTDialect>();
    registry.insert<isq::extra::ISQExtraDialect>();
}
} // namespace ir
} // namespace isq
