
#include "isq/Enums.h"
#include "isq/Operations.h"
#include "isq/passes/canonicalization/CanonicalizeAssert.h"
#include "mlir/Dialect/Arith/IR/Arith.h"
#include "mlir/IR/BuiltinAttributes.h"
#include "mlir/IR/MLIRContext.h"
#include "mlir/IR/PatternMatch.h"
#include "mlir/Pass/Pass.h"
#include "mlir/Support/LLVM.h"
#include <mlir/Support/LogicalResult.h>
namespace isq{
namespace ir{
namespace passes{
namespace canonicalize{

RemoveAssertTrue::RemoveAssertTrue(mlir::MLIRContext* ctx): mlir::OpRewritePattern<isq::ir::AssertOp>(ctx, 1){}
mlir::LogicalResult RemoveAssertTrue::matchAndRewrite(isq::ir::AssertOp op,  mlir::PatternRewriter &rewriter) const{
    if (auto cons = mlir::dyn_cast_or_null<mlir::arith::ConstantOp>(op.getCond().getDefiningOp())){
        mlir::BoolAttr attr = cons.getValue().dyn_cast_or_null<mlir::BoolAttr>();
        if (attr && attr.getValue()) {
            rewriter.eraseOp(op);
        }
        return mlir::success();
    }
    return mlir::failure();
}


}
}
}
}
