#include "isq/Dialect.h"
#include <llvm/Support/CommandLine.h>
#include <llvm/Support/TypeName.h>
#include <llvm/Support/raw_ostream.h>
#include <mlir/Dialect/Affine/IR/AffineOps.h>
#include <mlir/IR/MLIRContext.h>
#include <mlir/IR/PatternMatch.h>
#define STR_(x) #x
#define STR(x) STR_(x)
static void PrintVersion(mlir::raw_ostream &OS) {
  OS << '\n';
  OS << "isQ IR Codegen " << STR(ISQ_BUILD_SEMVER) << '\n';
  OS << "Git revision: "<<STR(ISQ_BUILD_REV)<< ((STR(ISQ_BUILD_FROZEN)[0])=='1'?"":" (dirty)") << "\n";
  OS << "Build type: "<<STR(ISQ_OPT_BUILD_TYPE)<<"\n";
  OS << "Website: https://arclight-quantum.github.io/isQ-Compiler/\n";
}


int main(int argc, char **argv) {
    llvm::cl::AddExtraVersionPrinter(PrintVersion);
    //mlir::DialectRegistry registry;
    //isq::ir::ISQToolsInitialize(registry);
    //mlir::MLIRContext context(registry);
    llvm::cl::ParseCommandLineOptions(argc, argv, "isQ-MLIR Test\n");
    return 0;
}