use std::io::BufRead;
use std::io::Write;
fn main() {
    let f = std::fs::File::open("src/facades/qir/shim/exports.txt").unwrap();
    for line in std::io::BufReader::new(f).lines() {
        if let Ok(line) = line {
            println!("cargo:rustc-link-arg=-Wl,--undefined={}", line);
        }
    }
    let mut r_dynamic = true;
    if let Ok(s) = std::env::var("CARGO_CFG_TARGET_OS"){
        if s=="windows"{
            r_dynamic = false;
        }
    }
    // Write environment variable TARGET into $OUT_DIR
    // Use rust file api
    let out_dir = 
        std::env::var("OUT_DIR").unwrap();
    let mut f = std::fs::File::create(out_dir.clone() + "/host_env.rs").unwrap();
    let code = 
        format!("pub const SIMULATOR_HOST: &str = \"{}\";", std::env::var("TARGET").unwrap());
    f.write_all(code.as_bytes()).unwrap();


    if r_dynamic{
        println!("cargo:rustc-link-arg=-rdynamic");
    }
    #[cfg(feature = "cuda")]
    println!("cargo:rustc-link-lib=dylib=qsim_kernel");
}
