{ enabledPlugins ? [ "qcis" ]
, lib
, vendor ? null
, gitignoreSource ? vendor.gitignoreSource
, mlir ? vendor.mlir
, callPackage
, isQVersion
, isQVersionHook
, isQRustPackages
, buildPackages
, stdenv
, gendef
}:
let
  rustPlatform = vendor.rustPlatform;
  llvm_tools = buildPackages.llvmPackages_17.llvm;
  availablePlugins = {
    qcis = {
      feature = "qcis";
      package = callPackage ./plugins/python-routing-plugin { };
    };
    cuda = {
      feature = "cuda";
      package = callPackage ./plugins/cuda-plugin { };
    };
    win32 = {
      feature = "win32";
      package = callPackage ./plugins/win32-plugin { };
    };
  };
  plugins = map (x: availablePlugins."${x}") enabledPlugins;
  pluginDeps = lib.catAttrs "package" plugins;
  pluginFeatures = lib.catAttrs "feature" plugins;
  pluginExports = builtins.foldl' (x: y: x // y) { } (lib.catAttrs "exports" plugins);
in
((isQRustPackages.workspace."isq-simulator" { }).override {
  features = pluginFeatures;
}).overrideAttrs (final: prev: ((pluginExports) // rec {
  buildInputs = prev.buildInputs ++ pluginDeps;
  nativeBuildInputs = prev.nativeBuildInputs ++ [ gendef ];
  ${if stdenv.hostPlatform.isWindows then "RUSTFLAGS" else null} = "-Zexport-executable-symbols";
  postInstall = ''
    src=${final.src}/simulator/;
    mkdir -p $bin/share/isq-simulator/;
    simulator_stub_path=$bin/share/isq-simulator/isq-simulator.ll
    mkdir -p $bin/share/isq-simulator
    cp $src/share/simulator-targets.json $bin/share/isq-simulator/
    ${llvm_tools}/bin/llvm-link $src/src/facades/qir/shim/qir_builtin/shim.ll \
    $src/src/facades/qir/shim/qsharp_core/shim.ll  \
    $src/src/facades/qir/shim/qsharp_foundation/shim.ll \
    $src/src/facades/qir/shim/isq/shim.ll -S -o $simulator_stub_path
  ''
  + lib.optionalString (!stdenv.hostPlatform.isWindows) ''
    
  ''
  + lib.optionalString (stdenv.hostPlatform.isWindows) ''
    mkdir -p $bin/lib/isq-simulator
    gendef - $bin/bin/simulator.exe | sed "s/LIBRARY.*/LIBRARY \"simulator.exe\"/g" > $bin/share/isq-simulator/isq-simulator.def
    x86_64-w64-mingw32-dlltool --dllname simulator.exe --def $bin/share/isq-simulator/isq-simulator.def --output-lib $bin/lib/isq-simulator/isq-simulator.a
  '';
  passthru.availablePlugins = availablePlugins;
  passthru.enabledPlugins = pluginDeps;
}
))
