#![feature(const_option)]
#![feature(const_option_ext)]
#![feature(const_trait_impl)]

pub const ISQ_BUILD_VERSION: Option<&'static str> = option_env!("ISQ_BUILD_VERSION");
pub const ISQ_BUILD_SEMVER : Option<&'static str> = option_env!("ISQ_BUILD_SEMVER");
pub const ISQ_BUILD_REV : Option<&'static str> = option_env!("ISQ_BUILD_REV");
pub const ISQ_BUILD_FROZEN : Option<&'static str> = option_env!("ISQ_BUILD_FROZEN");

const fn option_unwrap_or(s: Option<&'static str>, t: &'static str)->&'static str{
    if s.is_some(){
        return s.unwrap();
    }else{
        return t;
    }
}
pub struct ISQVersion;

impl ISQVersion{
    pub const fn build_version()->&'static str{
        option_unwrap_or(ISQ_BUILD_VERSION, "0.0.0")
    }
    pub const fn build_semver()->&'static str{
        option_unwrap_or(ISQ_BUILD_SEMVER,"0.0.0+unknown.badver")
    }
    pub const fn build_rev()->&'static str{
        option_unwrap_or(ISQ_BUILD_REV,"unknown")
    }
    pub fn build_frozen()->bool{
        ISQ_BUILD_FROZEN==Some("1")
    }
}
