{ pkgsBuildBuild, cmake, fetchurl, ninja, python3, git, vendor, buildPackages, lib, buildLlvmTools ? buildPackages.llvmPackages_17 }:
let
  stdenv = vendor.stdenvBuild;
  cmakeBuildType = if (stdenv.hostPlatform.isWindows) then "Release" else "RelWithDebInfo";
  flagsForLlvmConfig = [
    "-DLLVM_INSTALL_PACKAGE_DIR=${placeholder "dev"}/lib/cmake/llvm"
    "-DMLIR_INSTALL_PACKAGE_DIR=${placeholder "dev"}/lib/cmake/mlir"
    "-DLLD_INSTALL_PACKAGE_DIR=${placeholder "dev"}/lib/cmake/lld"
  ];
in
stdenv.mkDerivation {
  pname = "llvm-mlir";
  version = "17.0.3";
  #builder = ./builder.sh;
  src = fetchurl {
    url = "https://github.com/llvm/llvm-project/releases/download/llvmorg-17.0.3/llvm-project-17.0.3.src.tar.xz";
    hash = "sha256-vloeRNZPMGu0T859NuOzmTaU6OYSKyNIYIkGKDwXbbg=";
  };
  nativeBuildInputs = [ cmake ninja python3 git ];
  cmakeFlags = with stdenv; flagsForLlvmConfig ++ [
    "-DLLVM_ENABLE_PROJECTS=llvm;mlir;lld"
    "-DLLVM_BUILD_EXAMPLES=OFF"
    "-DLLVM_TARGETS_TO_BUILD=AArch64;ARM;BPF;Hexagon;LoongArch;MSP430;Mips;NVPTX;PowerPC;RISCV;Sparc;SystemZ;WebAssembly;X86"
    "-DLLVM_ENABLE_ASSERTIONS=ON"
    "-DLLVM_BUILD_TESTS=OFF"
    "-DMLIR_INCLUDE_TESTS=OFF"
    "-DLLVM_ENABLE_FFI=ON"
    "-DLLVM_ENABLE_DUMP=ON"
    "-DLLVM_HOST_TRIPLE=${stdenv.hostPlatform.config}"
    "-DLLVM_DEFAULT_TARGET_TRIPLE=${stdenv.hostPlatform.config}"
  ] ++ lib.optionals (!stdenv.buildPlatform.canExecute stdenv.hostPlatform) [
    "-DLLVM_NATIVE_TOOL_DIR=${buildLlvmTools.llvm}/bin/"
    "-DLLVM_TABLEGEN=${buildLlvmTools.llvm}/bin/llvm-tblgen"
    (
      let
        nativeCC = pkgsBuildBuild.targetPackages.stdenv.cc;
        nativeBintools = nativeCC.bintools.bintools;
        nativeToolchainFlags = [
          "-DCMAKE_C_COMPILER=${nativeCC}/bin/${nativeCC.targetPrefix}cc"
          "-DCMAKE_CXX_COMPILER=${nativeCC}/bin/${nativeCC.targetPrefix}c++"
          "-DCMAKE_AR=${nativeBintools}/bin/${nativeBintools.targetPrefix}ar"
          "-DCMAKE_STRIP=${nativeBintools}/bin/${nativeBintools.targetPrefix}strip"
          "-DCMAKE_RANLIB=${nativeBintools}/bin/${nativeBintools.targetPrefix}ranlib"
        ];
        # We need to repass the custom GNUInstallDirs values, otherwise CMake
        # will choose them for us, leading to wrong results in llvm-config-native
        nativeInstallFlags = [
          "-DCMAKE_INSTALL_PREFIX=${placeholder "out"}"
          "-DCMAKE_INSTALL_BINDIR=${placeholder "out"}/bin"
          "-DCMAKE_INSTALL_INCLUDEDIR=${placeholder "dev"}/include"
          "-DCMAKE_INSTALL_LIBDIR=${placeholder "lib"}/lib"
          "-DCMAKE_INSTALL_LIBEXECDIR=${placeholder "lib"}/libexec"
        ];
      in
      "-DCROSS_TOOLCHAIN_FLAGS_NATIVE:list="
        + lib.concatStringsSep ";" (lib.concatLists [
        flagsForLlvmConfig
        nativeToolchainFlags
        nativeInstallFlags
      ])
    )
  ] ++ lib.optionals (stdenv.hostPlatform.isWindows) [
    "-DCMAKE_BUILD_WITH_INSTALL_RPATH=ON"
    "-DBUILD_SHARED_LIBS=ON"
    #"-DBUILD_SHARED_LIBS=ON"
    # PE/COFF does not support total section name longer than 9999999.
    # As a result, debug info (-g) must be purged.
    # https://stackoverflow.com/questions/14125007/gcc-string-table-overflow-error-during-compilation/29479701#29479701

  ] ++ lib.optionals (!stdenv.hostPlatform.isWindows) [
    #"-DBUILD_SHARED_LIBS=ON"
    "-DBUILD_SHARED_LIBS=ON"
  ];
  patches = lib.optionals (stdenv.hostPlatform.isWindows) [
    ./68513-propagate-build-with-install-rpath.patch
    ./76739-mlir-tblgen-depends-on-support.patch
  ] ++ [
    ./gnu-install-dirs.patch
    ./lld-gnu-install-dirs.patch
    ./mlir-gnu-install-dirs.patch
  ];
  inherit cmakeBuildType;
  separateDebugInfo = stdenv.hostPlatform.isLinux;
  postInstall = ''
    mkdir -p $python/share
    mv $out/share/opt-viewer $python/share/opt-viewer
    moveToOutput "bin/llvm-config*" "$dev"
    substituteInPlace "$dev/lib/cmake/llvm/LLVMExports-${lib.strings.toLower cmakeBuildType}.cmake" \
      --replace "\''${_IMPORT_PREFIX}/lib/lib" "$lib/lib/lib" \
      --replace "$out/bin/llvm-config" "$dev/bin/llvm-config"
    substituteInPlace "$dev/lib/cmake/llvm/LLVMConfig.cmake" \
      --replace 'set(LLVM_BINARY_DIR "''${LLVM_INSTALL_PREFIX}")' 'set(LLVM_BINARY_DIR "'"$lib"'")'

    # MLIR
    substituteInPlace "$dev/lib/cmake/mlir/MLIRTargets-${lib.strings.toLower cmakeBuildType}.cmake" \
      --replace "\''${_IMPORT_PREFIX}/lib/lib" "$lib/lib/lib"
  ''
  + lib.optionalString (stdenv.buildPlatform != stdenv.hostPlatform) ''
    cp NATIVE/bin/llvm-config $dev/bin/llvm-config-native
  '';
  postFixup = lib.optionalString (stdenv.hostPlatform.isLinux) ''
    mkdir -p $debug
  '';
  cmakeDir = "../llvm";
  outputs = [ "out" "dev" "lib" "python" ];
}
